"use strict";


var PRODUCT_ID               = "travic-sign";
var PRODUCT_NAME             = "TRAVIC-Sign";

// Map used to map classIds in <object>-tag to mime-types
var CLASSID_TO_MIME_TYPE_MAP = [];
CLASSID_TO_MIME_TYPE_MAP["8124BF8C-E994-4214-8C5B-4E0C55D68FB7"] = "application/x-ppi-security-plugin-ebics-software";
CLASSID_TO_MIME_TYPE_MAP["663bD149-57B9-4EC0-BCFE-BED7133BCEC7"] = "application/x-ppi-security-plugin-ebics-chipcard";
CLASSID_TO_MIME_TYPE_MAP["65EEE2E1-B8D5-4724-8489-048B551045BF"] = "application/x-ppi-security-plugin-hbci-chipcard";
CLASSID_TO_MIME_TYPE_MAP["F7710E06-12DE-4D34-8A5D-5F212FE2A10A"] = "application/x-ppi-security-plugin-hbci-software";
CLASSID_TO_MIME_TYPE_MAP["E91825A5-E41C-4AF9-A4F6-6E7A3D4F07AE"] = "application/x-ppi-security-plugin-secoder";
CLASSID_TO_MIME_TYPE_MAP["8C75DB45-599F-4B6D-9342-1D2A90C2716F"] = "application/x-ppi-security-plugin-init-card";
CLASSID_TO_MIME_TYPE_MAP["8DAA51D2-6D08-4A1F-B17A-94B31DF10564"] = "application/x-ppi-security-plugin-init-soft";

// List of all supported mime types of this extension
var SUPPORTED_MIME_TYPES = [];
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-ebics-software");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-ebics-software-3.1.20.0");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-ebics-chipcard");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-ebics-chipcard-3.1.20.0");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-hbci-chipcard");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-hbci-chipcard-3.1.20.0");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-hbci-software");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-hbci-software-3.1.20.0");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-secoder");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-secoder-3.1.20.0");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-init-card");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-init-card-3.1.20.0");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-init-soft");
SUPPORTED_MIME_TYPES.push("application/x-ppi-security-plugin-init-soft-3.1.20.0");


/**
 * Checks whether a type is supported by this extension
 */
function isExtensionTypeSupported(type) {
    if (!type) {
        return false;
    }

    return ($.inArray(type.trim(), SUPPORTED_MIME_TYPES) >= 0);    
}

/**
 * Returns the id of the native messaging host
 */
function getNativeMessagingHostId() {
    return "de.ppi.travic.sign";
}    

/**
 * Checks whether the given URL is an absolute URL
 */
function isAbsoluteUrl(url) {
  return /^(?:\/|[a-z]+:\/\/)/.test(url.trim());
}

/**
 * Checks whether the given URL has a scheme.
 */
function hasUrlScheme(url) {
  return /^(?:[a-z]+:\/\/)/.test(url.trim());
}

/**
 * Returns only the path excluding the filename
 */
function getPathNameOnly(path) {
  var parts = path.trim().split('/');
  parts.pop();
  return parts.join("/") + "/";
}

/**
 * Adds characters to the left of a string until
 * the string is 'number' characters long.
 */
function padLeft(text, character, number) {
    while (text.toString().length < number) {
        text = character + text;
    }
    return text;
}

/**
 * Returns a date in format hh:mm:ss:ms
 */
function formatDateString(date) {
    var hour        = padLeft(date.getHours(),        '0', 2);
    var minute      = padLeft(date.getMinutes(),      '0', 2);
    var second      = padLeft(date.getSeconds(),      '0', 2);
    var millisecond = padLeft(date.getMilliseconds(), '0', 3);
    
    return hour + ":" + minute + ":" + second + ":" + millisecond;
}

/**
 * Returns an absolute URL based on the current window location.
 *
 * If the URL is relative, scheme and path of the current window location are prepended to the URL.
 * If there's no scheme, but the URL begins with a slash, the scheme of the current window location is prepended to the URL.
 */
function buildAbsoluteUrlOnCurrentLocation(url) {
    if (hasUrlScheme(url)) {
        return url;
    }

    if (isAbsoluteUrl(url)) {
        // If URL is absolute, add origin.
        return location.origin + url;
    }
    else {
        // If URL is relative, add origin and pathname.
        return location.origin + getPathNameOnly(location.pathname) + url;
    }
}

/**
 * Returns true if running in a Firefox
 */
function isFirefox() {
    var userAgent = navigator.userAgent;
    
    return (/Firefox[\/\s](\d+\.\d+)/.test(userAgent)); // Test for Firefox/x.x or Firefox x.x
}

function isSafari() {
    return typeof(safari) !== "undefined";
}

/**
 * Returns the Firefox version. If not running in Firefox -1 is returned.
 */
function getFirefoxVersion() {
    var userAgent = navigator.userAgent;

    if (/Firefox[\/\s](\d+\.\d+)/.test(userAgent)) { // Test for Firefox/x.x or Firefox x.x
        return RegExp.$1;
    }
    else {
        return "";
    }
}

/**
 * Returns the minimal required Firefox version
 */
function getMinRequiredFirefoxVersion() {
    return "58.0";
}

/**
 * Verifies the minimum required Firefox version
 */
function isFirefoxVersionSufficient() {
    var minimumFirefoxVersion = parseFloat(getMinRequiredFirefoxVersion());    
    var currentFirefoxVersion = parseFloat(getFirefoxVersion());
    
    return (currentFirefoxVersion >= minimumFirefoxVersion);
}

    
