"use strict";


/**
 * Version information service
 */
var versionInfoService = (function() {

    // Enable/disable debug log
    var debug = false;
    
    var version = "3.1.20.0";
    var observer = null;
           
    /**
     * Fills the version information in the tag with id '<PRODUCT_ID>-version'
     */
    function fillVersionTag() {
        var id = "#" + PRODUCT_ID + "-version";
        if ($(id).length) {
            var newText = version;
            var oldText = $(id).text();
            
            // Replace HTML content if different
            if (oldText != newText) {
                // Stop a running observer
                var observerWasRunning = isObserverRunning();      
                stopObserver();

                logDebug("Replacing version in element with id " + id);
                $(id).text(newText);

                // Restart observer
                if (observerWasRunning) {
                    startObserver();
                }
            }
        }
    }

    function startObserver() {
        if (isObserverRunning) {
            stopObserver();
        }
        
        logDebug("Starting observer to wait for version tag to appear");

        var observerConfig = {
            childList : true,
            attributes : false,
            characterData : false,
            subtree : true
        };
        
        observer = new MutationObserver(function(mutations) {
            fillVersionTag.call(this);
        });

        // Pass in the target node, as well as the observer options
        observer.observe(document, observerConfig);
        
        // Stop observer on unload
        $(window).on('beforeunload', function(){
            logDebug("Stopping observer for plugin instances");
            observer.disconnect();
        });
           
        logDebug("Observer started");           
    }
        
    function stopObserver() {
        if (isObserverRunning()) {
            observer.disconnect();
            observer = null;
        }
    }

    function isObserverRunning() {
        return (observer !== null);
    }
        
    function logDebug(message) {
        if (debug === true) {
            var dateString = formatDateString(new Date());
            console.debug(dateString + " - " + PRODUCT_NAME + " [VersionInfoService]: " + message);
        }
    }
    
    ///////////////////////////////////////////////////////////////
    // Public interface
    ///////////////////////////////////////////////////////////////

    return {
        
        // Initializes this service
        init : function() {  
            fillVersionTag();
            startObserver();
        },
        
        // Returns the extension version
        getVersion : function() {
            return version;
        }
    };    
    
})();
if (!isSafari()) {
    $(document).ready(function() {
        versionInfoService.init();
    });
}
