"use strict";

var optionsService = (function() {
    
    const KEY_DEBUG_ENABLED = "debugEnabled";
    
    var debugEnabled = false;

    if (isSafari()) {
        debugEnabled = true;
    }

    if (typeof(chrome) !== "undefined" && typeof(chrome.storage.local.get) == "function") {
        chrome.storage.local.get(KEY_DEBUG_ENABLED, function(item) {
            debugEnabled = item.debugEnabled;
        });
    }
    
    return {
                
        // Saves options to chrome.storage
        saveOptions: function() {
            if (typeof(chrome) !== "undefined" && typeof(chrome.storage.local.set) == "function") {
                chrome.storage.local.set({
                    KEY_DEBUG_ENABLED: debugEnabled
                });
            }
        },
        
        isDebugEnabled : function() {
            return debugEnabled;
        },
        
        setDebugEnabled : function(value) {
            debugEnabled = value;
        }
        
    };
    
})();
