"use strict";

/**
 * Load the options and update UI
 */
function loadOptions() {
    if (typeof(chrome.storage.local.get) == "function") {
        chrome.storage.local.get("debugEnabled", function(item) {
            var debugEnabled = item.debugEnabled;    
            $("#debugEnabled").prop("checked", debugEnabled);
        });
    }
}

/**
 * Save options
 */
function saveOptions() {
    var debugEnabled = $("#debugEnabled").is(":checked");
    if (typeof(chrome.storage.local.set) == "function") {
        chrome.storage.local.set({
            "debugEnabled": debugEnabled
        });
    }
            
    $("#status").text("Options updated");
    setTimeout(function() {
        $("#status").text("");
    },
    1500);
}

$(document).ready(function() {
    loadOptions();
    
    $("#debugEnabled").change(function() {
        saveOptions();
    });
});


