"use strict";

function newHtmlFragment() {

    function logDebug(message) {
        if (optionsService.isDebugEnabled()) {
            var dateString = formatDateString(new Date());
            console.debug(dateString + " - " + PRODUCT_NAME + " [HtmlFragment]: " + message);
        }
    }

    function logError(message) {
        var dateString = formatDateString(new Date());
        console.error(dateString + " - " + PRODUCT_NAME + " [HtmlFragment]: " + message);
    }
    
    return {
        
        /**
         * Load the HTML fragment for the main GUI and replaces the element with the id in 'targetElement'
         *
         * @param targetElement Element to be replaced the HTML content
         * @param successCallback Called when loading succeeds.
         * @param errorCallback Called when an error occured.
         */
        load : function(targetElement, successCallback, errorCallback) {
            var guiUrl;
            if (isSafari()) {
                guiUrl = safari.extension.baseURI + "gui.html";
            } else {
                guiUrl = chrome.runtime.getURL("gui.html");
            }
            logDebug("Loading HTML template from: " + guiUrl);     
        
            $(targetElement).load(guiUrl, function(response, status, xhr) {
                logDebug("Loading HTML template - status: " + status);
                if (status == "success") {
                    successCallback(response);
                }
                else {
                    errorCallback(status);
                }
            });
        }
        
    };

}